<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCarsTable extends Migration {

	public function up()
	{
		Schema::create('cars', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('board_number');
			$table->string('type');
			$table->string('model');
			$table->string('color');
			$table->string('form_number');
			$table->date('expiration_date');
			$table->string('counter_number');
			$table->integer('driver_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('cars');
	}
}