<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFieldReportsTable extends Migration {

	public function up()
	{
		Schema::create('field_reports', function(Blueprint $table) {
			$table->increments('id');
			$table->string('type');
			$table->integer('municipal_id')->unsigned()->nullable();
			$table->integer('district_id')->unsigned()->nullable();
			$table->double('latitude');
			$table->double('longitude');
			$table->text('notes')->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('field_reports');
	}
}