<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('municipal_id')->references('id')->on('municipals')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('districts')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('municipals', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->foreign('municipal_id')->references('id')->on('municipals')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('worktimes', function(Blueprint $table) {
			$table->foreign('municipal_id')->references('id')->on('municipals')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('worktimes', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('districts')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('worktimes', function(Blueprint $table) {
			$table->foreign('day_id')->references('id')->on('days')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('worktimes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('field_reports', function(Blueprint $table) {
			$table->foreign('municipal_id')->references('id')->on('municipals')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('field_reports', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('districts')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('field_reports', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('place_types', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('focal_types', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('aversion_types', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('aversion_shapes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('processing_types', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('treatment_methods', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('field_report_place_types', function(Blueprint $table) {
			$table->foreign('field_report_id')->references('id')->on('field_reports')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('field_report_place_types', function(Blueprint $table) {
			$table->foreign('place_type_id')->references('id')->on('place_types')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('field_report_focal_types', function(Blueprint $table) {
			$table->foreign('field_report_id')->references('id')->on('field_reports')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('field_report_focal_types', function(Blueprint $table) {
			$table->foreign('focal_type_id')->references('id')->on('focal_types')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('causes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('field_report_causes', function(Blueprint $table) {
			$table->foreign('field_report_id')->references('id')->on('field_reports')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('field_report_causes', function(Blueprint $table) {
			$table->foreign('cause_id')->references('id')->on('causes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('field_report_aversion_types', function(Blueprint $table) {
			$table->foreign('aversion_type_id')->references('id')->on('aversion_types')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('focal_moods', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('field_report_focal_moods', function(Blueprint $table) {
			$table->foreign('focal_mood_id')->references('id')->on('focal_moods')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('field_report_aversion_shapes', function(Blueprint $table) {
			$table->foreign('field_report_id')->references('id')->on('field_reports')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('field_report_aversion_shapes', function(Blueprint $table) {
			$table->foreign('aversion_shape_id')->references('id')->on('aversion_shapes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('field_report_procedures', function(Blueprint $table) {
			$table->foreign('field_report_id')->references('id')->on('field_reports')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('field_report_procedures', function(Blueprint $table) {
			$table->foreign('procedure_id')->references('id')->on('procedures')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('procedures', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('field_report_processing_types', function(Blueprint $table) {
			$table->foreign('field_report_id')->references('id')->on('field_reports')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('field_report_processing_types', function(Blueprint $table) {
			$table->foreign('processing_type_id')->references('id')->on('processing_types')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('field_report_treatment_methods', function(Blueprint $table) {
			$table->foreign('field_report_id')->references('id')->on('field_reports')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('field_report_treatment_methods', function(Blueprint $table) {
			$table->foreign('treatment_method_id')->references('id')->on('treatment_methods')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('fighting_materials', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('field_report_fighting_materials', function(Blueprint $table) {
			$table->foreign('field_report_id')->references('id')->on('field_reports')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('field_report_fighting_materials', function(Blueprint $table) {
			$table->foreign('fighting_material_id')->references('id')->on('fighting_materials')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('drivers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('drivers', function(Blueprint $table) {
			$table->foreign('municipal_id')->references('id')->on('municipals')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('workers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('workers', function(Blueprint $table) {
			$table->foreign('municipal_id')->references('id')->on('municipals')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('drivers')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('equipments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('equipments', function(Blueprint $table) {
			$table->foreign('car_id')->references('id')->on('cars')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('driver_districts', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('drivers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('driver_districts', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('districts')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('worker_districts', function(Blueprint $table) {
			$table->foreign('worker_id')->references('id')->on('workers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('worker_districts', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('districts')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_job_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_team_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_municipal_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_district_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_user_id_foreign');
		});
		Schema::table('municipals', function(Blueprint $table) {
			$table->dropForeign('municipals_user_id_foreign');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->dropForeign('districts_user_id_foreign');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->dropForeign('districts_municipal_id_foreign');
		});
		Schema::table('worktimes', function(Blueprint $table) {
			$table->dropForeign('worktimes_municipal_id_foreign');
		});
		Schema::table('worktimes', function(Blueprint $table) {
			$table->dropForeign('worktimes_district_id_foreign');
		});
		Schema::table('worktimes', function(Blueprint $table) {
			$table->dropForeign('worktimes_day_id_foreign');
		});
		Schema::table('worktimes', function(Blueprint $table) {
			$table->dropForeign('worktimes_user_id_foreign');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->dropForeign('teams_user_id_foreign');
		});
		Schema::table('field_reports', function(Blueprint $table) {
			$table->dropForeign('field_reports_municipal_id_foreign');
		});
		Schema::table('field_reports', function(Blueprint $table) {
			$table->dropForeign('field_reports_district_id_foreign');
		});
		Schema::table('field_reports', function(Blueprint $table) {
			$table->dropForeign('field_reports_user_id_foreign');
		});
		Schema::table('place_types', function(Blueprint $table) {
			$table->dropForeign('place_types_user_id_foreign');
		});
		Schema::table('focal_types', function(Blueprint $table) {
			$table->dropForeign('focal_types_user_id_foreign');
		});
		Schema::table('aversion_types', function(Blueprint $table) {
			$table->dropForeign('aversion_types_user_id_foreign');
		});
		Schema::table('aversion_shapes', function(Blueprint $table) {
			$table->dropForeign('aversion_shapes_user_id_foreign');
		});
		Schema::table('processing_types', function(Blueprint $table) {
			$table->dropForeign('processing_types_user_id_foreign');
		});
		Schema::table('treatment_methods', function(Blueprint $table) {
			$table->dropForeign('treatment_methods_user_id_foreign');
		});
		Schema::table('field_report_place_types', function(Blueprint $table) {
			$table->dropForeign('field_report_place_types_field_report_id_foreign');
		});
		Schema::table('field_report_place_types', function(Blueprint $table) {
			$table->dropForeign('field_report_place_types_place_type_id_foreign');
		});
		Schema::table('field_report_focal_types', function(Blueprint $table) {
			$table->dropForeign('field_report_focal_types_field_report_id_foreign');
		});
		Schema::table('field_report_focal_types', function(Blueprint $table) {
			$table->dropForeign('field_report_focal_types_focal_type_id_foreign');
		});
		Schema::table('causes', function(Blueprint $table) {
			$table->dropForeign('causes_user_id_foreign');
		});
		Schema::table('field_report_causes', function(Blueprint $table) {
			$table->dropForeign('field_report_causes_field_report_id_foreign');
		});
		Schema::table('field_report_causes', function(Blueprint $table) {
			$table->dropForeign('field_report_causes_cause_id_foreign');
		});
		Schema::table('field_report_aversion_types', function(Blueprint $table) {
			$table->dropForeign('field_report_aversion_types_aversion_type_id_foreign');
		});
		Schema::table('focal_moods', function(Blueprint $table) {
			$table->dropForeign('focal_moods_user_id_foreign');
		});
		Schema::table('field_report_focal_moods', function(Blueprint $table) {
			$table->dropForeign('field_report_focal_moods_focal_mood_id_foreign');
		});
		Schema::table('field_report_aversion_shapes', function(Blueprint $table) {
			$table->dropForeign('field_report_aversion_shapes_field_report_id_foreign');
		});
		Schema::table('field_report_aversion_shapes', function(Blueprint $table) {
			$table->dropForeign('field_report_aversion_shapes_aversion_shape_id_foreign');
		});
		Schema::table('field_report_procedures', function(Blueprint $table) {
			$table->dropForeign('field_report_procedures_field_report_id_foreign');
		});
		Schema::table('field_report_procedures', function(Blueprint $table) {
			$table->dropForeign('field_report_procedures_procedure_id_foreign');
		});
		Schema::table('procedures', function(Blueprint $table) {
			$table->dropForeign('procedures_user_id_foreign');
		});
		Schema::table('field_report_processing_types', function(Blueprint $table) {
			$table->dropForeign('field_report_processing_types_field_report_id_foreign');
		});
		Schema::table('field_report_processing_types', function(Blueprint $table) {
			$table->dropForeign('field_report_processing_types_processing_type_id_foreign');
		});
		Schema::table('field_report_treatment_methods', function(Blueprint $table) {
			$table->dropForeign('field_report_treatment_methods_field_report_id_foreign');
		});
		Schema::table('field_report_treatment_methods', function(Blueprint $table) {
			$table->dropForeign('field_report_treatment_methods_treatment_method_id_foreign');
		});
		Schema::table('fighting_materials', function(Blueprint $table) {
			$table->dropForeign('fighting_materials_user_id_foreign');
		});
		Schema::table('field_report_fighting_materials', function(Blueprint $table) {
			$table->dropForeign('field_report_fighting_materials_field_report_id_foreign');
		});
		Schema::table('field_report_fighting_materials', function(Blueprint $table) {
			$table->dropForeign('field_report_fighting_materials_fighting_material_id_foreign');
		});
		Schema::table('drivers', function(Blueprint $table) {
			$table->dropForeign('drivers_user_id_foreign');
		});
		Schema::table('drivers', function(Blueprint $table) {
			$table->dropForeign('drivers_municipal_id_foreign');
		});
		Schema::table('workers', function(Blueprint $table) {
			$table->dropForeign('workers_user_id_foreign');
		});
		Schema::table('workers', function(Blueprint $table) {
			$table->dropForeign('workers_municipal_id_foreign');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->dropForeign('cars_user_id_foreign');
		});
		Schema::table('cars', function(Blueprint $table) {
			$table->dropForeign('cars_driver_id_foreign');
		});
		Schema::table('equipments', function(Blueprint $table) {
			$table->dropForeign('equipments_user_id_foreign');
		});
		Schema::table('equipments', function(Blueprint $table) {
			$table->dropForeign('equipments_car_id_foreign');
		});
		Schema::table('driver_districts', function(Blueprint $table) {
			$table->dropForeign('driver_districts_driver_id_foreign');
		});
		Schema::table('driver_districts', function(Blueprint $table) {
			$table->dropForeign('driver_districts_district_id_foreign');
		});
		Schema::table('worker_districts', function(Blueprint $table) {
			$table->dropForeign('worker_districts_worker_id_foreign');
		});
		Schema::table('worker_districts', function(Blueprint $table) {
			$table->dropForeign('worker_districts_district_id_foreign');
		});
	}
}