<?php

namespace App\Models\Field;

class FieldReport extends Eloquent {

	protected $table = 'field_reports';
	public $timestamps = true;

	public function municipal()
	{
		return $this->belongsTo('Municipal');
	}

	public function district()
	{
		return $this->belongsTo('District');
	}

	public function place_types()
	{
		return $this->hasMany('FieldReportPlaceType');
	}

	public function focal_types()
	{
		return $this->hasMany('FieldReportFocalType');
	}

	public function causes()
	{
		return $this->hasMany('FieldReportCause');
	}

	public function aversion_types()
	{
		return $this->hasMany('FieldReportAversionType');
	}

	public function aversion_shapes()
	{
		return $this->hasMany('FieldReportAversionShape');
	}

	public function procedures()
	{
		return $this->hasMany('FieldReportProcedure');
	}

	public function processing_types()
	{
		return $this->hasMany('FieldReportProcessingType');
	}

	public function treatment_methods()
	{
		return $this->hasMany('FieldReportTreatmentMethod');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function fighting_materials()
	{
		return $this->hasMany('FieldReportFightingMaterial');
	}

}