<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('test2', function(Blueprint $table) {
			$table->foreign('test_id')->references('id')->on('test')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('test3', function(Blueprint $table) {
			$table->foreign('test_id')->references('id')->on('test')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('test3', function(Blueprint $table) {
			$table->foreign('test2_id')->references('test_id')->on('test2')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('test2', function(Blueprint $table) {
			$table->dropForeign('test2_test_id_foreign');
		});
		Schema::table('test3', function(Blueprint $table) {
			$table->dropForeign('test3_test_id_foreign');
		});
		Schema::table('test3', function(Blueprint $table) {
			$table->dropForeign('test3_test2_id_foreign');
		});
	}
}