<?php

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;

class DatabaseSeeder extends Seeder {

	public function run()
	{
		Model::unguard();

		$this->call('UsersTableSeeder');
		$this->command->info('Users table seeded!');

		$this->call('RoleGroupTableSeeder');
		$this->command->info('RoleGroup table seeded!');

		$this->call('UserHasRolesTableSeeder');
		$this->command->info('UserHasRoles table seeded!');

		$this->call('RolesTableSeeder');
		$this->command->info('Roles table seeded!');

		$this->call('ModuleHasPermissionsTableSeeder');
		$this->command->info('ModuleHasPermissions table seeded!');

		$this->call('ModulesTableSeeder');
		$this->command->info('Modules table seeded!');

		$this->call('PermissionTableSeeder');
		$this->command->info('Permission table seeded!');

		$this->call('OrganizationsTableSeeder');
		$this->command->info('Organizations table seeded!');
	}
}