<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentTransfersTable extends Migration {

	public function up()
	{
		Schema::create('payment_transfers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('course_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->string('image')->nullable();
			$table->integer('course_request_id')->unsigned();
			$table->integer('bank_id')->unsigned()->nullable();
			$table->enum('type', array(''visa'', ''bank'', ''paypal'', ''zbony'', ''sala''))->nullable();
			$table->string('user_bank_name')->nullable();
			$table->integer('user_account_number')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('payment_transfers');
	}
}