<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReferenceSummariesTable extends Migration {

	public function up()
	{
		Schema::create('reference_summaries', function(Blueprint $table) {
			$table->increments('id');
			$table->string('image')->nullable();
			$table->json('title')->nullable();
			$table->integer('category_id')->unsigned()->nullable();
			$table->json('description')->nullable();
			$table->json('inside_advise')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reference_summaries');
	}
}