<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username')->nullable();
			$table->string('email')->nullable();
			$table->string('mobile')->nullable();
			$table->integer('country_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('image')->nullable();
			$table->string('password');
			$table->enum('status', array(''active'', ''not_active''))->nullable();
			$table->timestamps();
			$table->string('verification_code')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}