<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDownloadRequestsTable extends Migration {

	public function up()
	{
		Schema::create('download_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('topic_liberary_id')->unsigned();
			$table->enum('payment_type', array(''visa'', ''bank'', ''paypal'', ''zbony'', ''sala''))->nullable();
			$table->enum('paid', array(''free'', ''paid''))->nullable();
			$table->string('price')->nullable();
			$table->integer('bank_id')->unsigned()->nullable();
			$table->string('transfer_image')->nullable();
			$table->enum('status', array(''waiting'', ''finished'', ''paid''))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('download_requests');
	}
}