<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned()->nullable();
			$table->json('body')->nullable();
			$table->enum('type', array(''admin'', ''download'', ''course''))->nullable();
			$table->string('side_col')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}