<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRevisionRequestsTable extends Migration {

	public function up()
	{
		Schema::create('revision_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('code')->nullable();
			$table->string('name')->nullable();
			$table->string('email')->nullable();
			$table->text('body')->nullable();
			$table->string('document')->nullable();
			$table->integer('revision_price_id')->unsigned()->nullable();
			$table->enum('status', array(''waiting'', ''finished'', ''paid''))->nullable();
			$table->enum('payment_type', array(''visa'', ''bank'', ''paypal'', ''zbony'', ''sala''))->nullable();
			$table->integer('bank_id')->unsigned()->nullable();
			$table->string('transfer_image')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('revision_requests');
	}
}