<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSkillsTable extends Migration {

	public function up()
	{
		Schema::create('skills', function(Blueprint $table) {
			$table->increments('id', true);
			$table->uuid('uuid')->unique();
			$table->string('group_uuid');
			$table->string('name');
			$table->string('lang');
			$table->boolean('enabled')->default(false);
			$table->string('source_file')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('skills');
	}
}