<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Skill extends Eloquent {

	protected $table = 'skills';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function belongsToMany()
	{
		return $this->belongsToMany('App\Models\SkillParent', 'skill_id');
	}

	public function belongsToCategories()
	{
		return $this->belongsToMany('App\Models\SkillCategoriesRel', 'skill_uuid');
	}

}