<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormateursTable extends Migration {

	public function up()
	{
		Schema::create('formateurs', function(Blueprint $table) {
			$table->string('formateur_id')->unique()->primary();
			$table->string('genre');
			$table->string('prenom');
			$table->string('nom');
			$table->date('date_naissance');
			$table->string('lieu_naissance');
			$table->string('pays_naissance');
			$table->string('nationalite');
			$table->string('numero_cni');
			$table->string('rib');
			$table->string('email');
			$table->string('adresse_ligne1');
			$table->string('adresse_ligne2');
			$table->string('telephone_mobile');
			$table->string('telephone_fixe');
			$table->string('prenom_nom_pac');
			$table->string('lien_parente');
			$table->string('adresse_pac');
			$table->string('email_pac');
			$table->string('telephone_mobile_pac');
			$table->string('telephone_fixe_pac');
			$table->string('diplomes');
			$table->string('date_entree');
			$table->string('type_contrat')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('formateurs');
	}
}