<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShippingInsurance extends Model 
{

    protected $table = 'shipping_insurances';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function rates()
    {
        return $this->belongsToMany('ShippingRate');
    }

    public function ranges()
    {
        return $this->hasMany('ShippingInsuranceRange');
    }

}