<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShippingLabel extends Model 
{

    protected $table = 'shipping_labels';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('barcode', 'shipping_product_id', 'weight', 'weight_carrier', 'addres_from', 'address_to', 'status');

    public function product()
    {
        return $this->hasOne('ShippingProduct');
    }

    public function company()
    {
        return $this->hasOne('ShippingComany');
    }

    public function rate()
    {
        return $this->hasOne('ShippingRate');
    }

}