<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShippingProduct extends Model 
{

    protected $table = 'shipping_products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function shipping_company()
    {
        return $this->belongsTo('ShippingComany');
    }

    public function rates()
    {
        return $this->hasMany('ShippingRate');
    }

}