<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ShippingRateRange extends Eloquent {

	protected $table = 'shipping_rate_ranges';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('weight_from', 'weight_until', 'price');

	public function rate()
	{
		return $this->belongsTo('ShippingRate');
	}

}