<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCharitiesTable extends Migration {

	public function up()
	{
		Schema::create('charities', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('mission', 100);
			$table->text('about');
			$table->string('logo', 255)->nullable();
			$table->text('photos')->nullable();
			$table->text('contact_details');
			$table->string('contact_name', 100);
			$table->string('contact_position', 100);
			$table->string('contact_email', 255);
			$table->string('contact_telephone', 15);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('charities');
	}
}