<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCharityBranchesTable extends Migration {

	public function up()
	{
		Schema::create('charity_branches', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('charity_id');
			$table->text('description')->nullable();
			$table->string('name', 100);
			$table->string('addr_line1', 100);
			$table->string('addr_line2', 100);
			$table->string('addr_town', 100);
			$table->string('addr_county', 100);
			$table->string('addr_postcode', 10);
			$table->text('contact_details')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('charity_branches');
	}
}