<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFaqsTable extends Migration {

	public function up()
	{
		Schema::create('faqs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->longText('question');
			$table->longText('answer');
			$table->boolean('is_active');
			$table->bigInteger('company_id')->unsigned();
			$table->bigInteger('job_vacancy_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('faqs');
	}
}