<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('clinics', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('clinic_doctor', function(Blueprint $table) {
			$table->foreign('clinic_id')->references('id')->on('clinics')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('clinic_doctor', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('clinic_id')->references('id')->on('clinics')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('clinics', function(Blueprint $table) {
			$table->dropForeign('clinics_branch_id_foreign');
		});
		Schema::table('clinic_doctor', function(Blueprint $table) {
			$table->dropForeign('clinic_doctor_clinic_id_foreign');
		});
		Schema::table('clinic_doctor', function(Blueprint $table) {
			$table->dropForeign('clinic_doctor_doctor_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_clinic_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_doctor_id_foreign');
		});
	}
}