<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_no')->nullable();
			$table->integer('user_id')->unsigned();
			$table->string('payment_method', 256)->nullable();
			$table->string('razorpay_orderid', 256)->nullable();
			$table->date('delivery_date')->nullable();
			$table->integer('delivery_fee')->default('0');
			$table->double('tax')->nullable();
			$table->bigInteger('amount')->nullable();
			$table->bigInteger('grand_total')->nullable();
			$table->integer('order_status_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}