<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_otp', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_attributes', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_attributes_size', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('category_attributes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products_attributes', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products_attributes', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('category_attributes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products_attributes_size', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products_attributes_size', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('category_attributes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products_attributes_size', function(Blueprint $table) {
			$table->foreign('size_id')->references('id')->on('category_attributes_size')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_category', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_category', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('related_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('related_products', function(Blueprint $table) {
			$table->foreign('related_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('delivery_address', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('order_status_id')->references('id')->on('order_status')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_products', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('order')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_status', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('status')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->dropForeign('role_has_permissions_role_id_foreign');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->dropForeign('role_has_permissions_permission_id_foreign');
		});
		Schema::table('user_otp', function(Blueprint $table) {
			$table->dropForeign('user_otp_user_id_foreign');
		});
		Schema::table('category_attributes', function(Blueprint $table) {
			$table->dropForeign('category_attributes_category_id_foreign');
		});
		Schema::table('category_attributes_size', function(Blueprint $table) {
			$table->dropForeign('category_attributes_size_attribute_id_foreign');
		});
		Schema::table('products_attributes', function(Blueprint $table) {
			$table->dropForeign('products_attributes_product_id_foreign');
		});
		Schema::table('products_attributes', function(Blueprint $table) {
			$table->dropForeign('products_attributes_attribute_id_foreign');
		});
		Schema::table('products_attributes_size', function(Blueprint $table) {
			$table->dropForeign('products_attributes_size_product_id_foreign');
		});
		Schema::table('products_attributes_size', function(Blueprint $table) {
			$table->dropForeign('products_attributes_size_attribute_id_foreign');
		});
		Schema::table('products_attributes_size', function(Blueprint $table) {
			$table->dropForeign('products_attributes_size_size_id_foreign');
		});
		Schema::table('product_category', function(Blueprint $table) {
			$table->dropForeign('product_category_product_id_foreign');
		});
		Schema::table('product_category', function(Blueprint $table) {
			$table->dropForeign('product_category_category_id_foreign');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->dropForeign('product_images_product_id_foreign');
		});
		Schema::table('related_products', function(Blueprint $table) {
			$table->dropForeign('related_products_product_id_foreign');
		});
		Schema::table('related_products', function(Blueprint $table) {
			$table->dropForeign('related_products_related_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_user_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_product_id_foreign');
		});
		Schema::table('delivery_address', function(Blueprint $table) {
			$table->dropForeign('delivery_address_user_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_user_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_order_status_id_foreign');
		});
		Schema::table('order_products', function(Blueprint $table) {
			$table->dropForeign('order_products_order_id_foreign');
		});
		Schema::table('order_products', function(Blueprint $table) {
			$table->dropForeign('order_products_product_id_foreign');
		});
		Schema::table('order_status', function(Blueprint $table) {
			$table->dropForeign('order_status_status_id_foreign');
		});
	}
}