<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 256)->nullable();
			$table->text('features')->nullable();
			$table->text('details')->nullable();
			$table->text('image')->nullable();
			$table->bigInteger('price')->default('0');
			$table->double('tax')->nullable();
			$table->bigInteger('total_price')->nullable();
			$table->tinyInteger('status')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}