<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 256)->nullable();
			$table->string('slug', 256)->nullable();
			$table->text('description')->nullable();
			$table->text('left_image')->nullable();
			$table->text('right_image')->nullable();
			$table->text('video_link')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}