<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormsTable extends Migration {

	public function up()
	{
		Schema::create('forms', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('type_id')->unsigned();
			$table->integer('priority_id')->unsigned();
			$table->string('longitude', 255);
			$table->string('latitude', 255);
			$table->timestamps();
			$table->softDeletes();
			$table->text('comment')->nullable();
			$table->integer('area_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('forms');
	}
}