<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTransTable extends Migration {

	public function up()
	{
		Schema::create('ProductTrans', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('DocsNo', 30);
			$table->enum('Types', array('B=Builling', 'P=Purchasing', 'I=Issue', 'A=Adjust'));
			$table->integer('Product_id')->unsigned()->index();
			$table->integer('Lot_id')->unsigned()->index();
			$table->integer('Qty');
			$table->decimal('Cost');
			$table->decimal('Amount');
			$table->decimal('Unitprice');
			$table->decimal('discount');
			$table->integer('Unit_id');
		});
	}

	public function down()
	{
		Schema::drop('ProductTrans');
	}
}