<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('Customers', function(Blueprint $table) {
			$table->integer('id')->unique();
			$table->string('Cus_no', 30)->unique();
			$table->timestamps();
			$table->softDeletes();
			$table->string('Created_by', 30);
			$table->string('Updated_by', 30);
			$table->integer('parent_id');
			$table->string('Title', 30);
			$table->string('Name', 255);
			$table->string('Taxid', 20);
			$table->string('Contact', 255);
			$table->string('Address1', 255);
			$table->string('Address2', 255);
			$table->string('zipcode', 10);
			$table->string('Phone', 150);
			$table->string('fax', 150);
			$table->text('maps');
			$table->decimal('maxcardit');
			$table->integer('Cardit_day');
			$table->string('websites', 255);
			$table->string('email', 255);
			$table->integer('categoryid')->unsigned();
			$table->integer('rating');
			$table->integer('province')->unsigned();
			$table->text('Notes');
		});
	}

	public function down()
	{
		Schema::drop('Customers');
	}
}