<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuppliersTable extends Migration {

	public function up()
	{
		Schema::create('Suppliers', function(Blueprint $table) {
			$table->increments('ID');
			$table->timestamps();
			$table->softDeletes();
			$table->string('Created_by', 30);
			$table->string('Updated_by', 30);
			$table->string('Supplier_no', 30)->unique();
			$table->string('Title');
			$table->string('Name', 255);
			$table->string('Address1', 255);
			$table->string('Address2', 255);
			$table->string('Taxid', 20);
			$table->string('Phone', 150);
			$table->string('Fax', 150);
			$table->string('zipcode', 10);
			$table->string('Website', 255);
			$table->string('Email', 255);
			$table->string('Contact', 255);
			$table->string('Maps', 255);
			$table->string('Conditions', 255);
			$table->text('photo1');
			$table->integer('rating');
			$table->integer('province');
			$table->integer('category_id')->unsigned();
			$table->text('Notes');
		});
	}

	public function down()
	{
		Schema::drop('Suppliers');
	}
}