<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePurchaseordersTable extends Migration {

	public function up()
	{
		Schema::create('purchaseorders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('Status', array('Draft', 'Sent', 'Approved', 'PendingDeliver', 'Deliver', 'Cancel', 'Hold'));
			$table->integer('Supplier_id')->unique()->unsigned();
			$table->string('Ref_Doc');
			$table->datetime('Doc_date');
			$table->string('Created_by', 30);
			$table->string('Updated_by', 30);
			$table->text('Notes');
			$table->date('deliverydate');
			$table->string('delivery_by', 255);
			$table->string('deliveryto', 255);
			$table->string('ref1', 255);
			$table->string('ref2', 255);
			$table->string('ref3', 255);
			$table->string('ref4', 255);
			$table->string('ref5', 255);
			$table->string('Doc_No', 30)->unique();
			$table->string('Description', 255);
			$table->decimal('total');
			$table->decimal('discount');
			$table->string('discount_ref', 255);
			$table->decimal('total_after_discount');
			$table->integer('Vat');
			$table->decimal('vatadmount');
			$table->integer('Empi');
			$table->decimal('Totalamount');
		});
	}

	public function down()
	{
		Schema::drop('purchaseorders');
	}
}