<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('Invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('Status');
			$table->integer('cus_id')->unsigned();
			$table->string('Ref_Doc');
			$table->datetime('Doc_date');
			$table->string('Created_by', 30);
			$table->string('Updated_by', 30);
			$table->text('Notes');
			$table->date('deliverfydate');
			$table->string('delivery_by', 255);
			$table->string('delivertyto', 255);
			$table->string('ref1', 255);
			$table->string('ref2', 255);
			$table->string('ref3', 255);
			$table->string('ref4', 255);
			$table->string('ref5', 255);
			$table->string('Doc_No', 30);
			$table->string('Description', 255);
			$table->decimal('Total');
			$table->decimal('discount');
			$table->string('discount_ref', 255);
			$table->decimal('total_after_discount');
			$table->decimal('Vat');
			$table->decimal('vatadmount');
			$table->decimal('Totalamount');
			$table->integer('Empid');
		});
	}

	public function down()
	{
		Schema::drop('Invoices');
	}
}