<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Customers', function(Blueprint $table) {
			$table->foreign('categoryid')->references('id')->on('Istabs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Customers', function(Blueprint $table) {
			$table->foreign('province')->references('id')->on('Istabs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Suppliers', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('Istabs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->foreign('Unit_id')->references('id')->on('Units')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Product_locate', function(Blueprint $table) {
			$table->foreign('warehouse_id')->references('id')->on('WareHouses')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('purchaseorders', function(Blueprint $table) {
			$table->foreign('Supplier_id')->references('ID')->on('Suppliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Invoices', function(Blueprint $table) {
			$table->foreign('cus_id')->references('id')->on('Customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ProductTrans', function(Blueprint $table) {
			$table->foreign('Product_id')->references('id')->on('Products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ProductTrans', function(Blueprint $table) {
			$table->foreign('Lot_id')->references('id')->on('LOTs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Product_Categorys', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Product_Categorys', function(Blueprint $table) {
			$table->foreign('cate_id')->references('id')->on('Istabs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Members', function(Blueprint $table) {
			$table->foreign('cus_no')->references('id')->on('Customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Contacts', function(Blueprint $table) {
			$table->foreign('Supplier_id')->references('ID')->on('Suppliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Shippingaddresses', function(Blueprint $table) {
			$table->foreign('cus_id')->references('id')->on('Customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Promotion_Customer', function(Blueprint $table) {
			$table->foreign('promotion_id')->references('id')->on('Promotions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Promotion_Customer', function(Blueprint $table) {
			$table->foreign('cus_id')->references('id')->on('Customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Saleprices', function(Blueprint $table) {
			$table->foreign('Istabid')->references('id')->on('Istabs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Saleprices', function(Blueprint $table) {
			$table->foreign('cus_id')->references('id')->on('Customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Saleprices', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Customers', function(Blueprint $table) {
			$table->dropForeign('Customers_categoryid_foreign');
		});
		Schema::table('Customers', function(Blueprint $table) {
			$table->dropForeign('Customers_province_foreign');
		});
		Schema::table('Suppliers', function(Blueprint $table) {
			$table->dropForeign('Suppliers_category_id_foreign');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->dropForeign('Products_Unit_id_foreign');
		});
		Schema::table('Product_locate', function(Blueprint $table) {
			$table->dropForeign('Product_locate_warehouse_id_foreign');
		});
		Schema::table('purchaseorders', function(Blueprint $table) {
			$table->dropForeign('purchaseorders_Supplier_id_foreign');
		});
		Schema::table('Invoices', function(Blueprint $table) {
			$table->dropForeign('Invoices_cus_id_foreign');
		});
		Schema::table('ProductTrans', function(Blueprint $table) {
			$table->dropForeign('ProductTrans_Product_id_foreign');
		});
		Schema::table('ProductTrans', function(Blueprint $table) {
			$table->dropForeign('ProductTrans_Lot_id_foreign');
		});
		Schema::table('Product_Categorys', function(Blueprint $table) {
			$table->dropForeign('Product_Categorys_product_id_foreign');
		});
		Schema::table('Product_Categorys', function(Blueprint $table) {
			$table->dropForeign('Product_Categorys_cate_id_foreign');
		});
		Schema::table('Members', function(Blueprint $table) {
			$table->dropForeign('Members_cus_no_foreign');
		});
		Schema::table('Contacts', function(Blueprint $table) {
			$table->dropForeign('Contacts_Supplier_id_foreign');
		});
		Schema::table('Shippingaddresses', function(Blueprint $table) {
			$table->dropForeign('Shippingaddresses_cus_id_foreign');
		});
		Schema::table('Promotion_Customer', function(Blueprint $table) {
			$table->dropForeign('Promotion_Customer_promotion_id_foreign');
		});
		Schema::table('Promotion_Customer', function(Blueprint $table) {
			$table->dropForeign('Promotion_Customer_cus_id_foreign');
		});
		Schema::table('Saleprices', function(Blueprint $table) {
			$table->dropForeign('Saleprices_Istabid_foreign');
		});
		Schema::table('Saleprices', function(Blueprint $table) {
			$table->dropForeign('Saleprices_cus_id_foreign');
		});
		Schema::table('Saleprices', function(Blueprint $table) {
			$table->dropForeign('Saleprices_product_id_foreign');
		});
	}
}