<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAvisPermutationsTable extends Migration {

	public function up()
	{
		Schema::create('avis_permutations', function(Blueprint $table) {
			$table->bigInteger('id');
			$table->bigInteger('agent_demandeur_id')->unsigned()->index();
			$table->integer('ecole_destination_id')->nullable()->index()->default('NULL');
			$table->bigInteger('agent_interesse_id')->unsigned()->nullable()->index()->default('NULL');
			$table->datetime('date_publication');
			$table->datetime('date_reservation')->nullable();
			$table->enum('etat', array('Inactif', 'Libre', 'Reserve', 'Confirme', 'V'));
		});
	}

	public function down()
	{
		Schema::drop('avis_permutations');
	}
}