<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigInteger('id')->primary();
			$table->enum('type', array('admin', 'user'));
			$table->string('name', 255);
			$table->string('email', 255)->index()->default('NULL');
			$table->timestamps();
			$table->string('password', 255)->default('NULL');
			$table->timestamps();
			$table->smallInteger('active')->unsigned()->default('1');
			$table->string('timezone', 255)->nullable()->default('NULL');
			$table->timestamps();
			$table->string('last_login_ip', 255)->nullable()->default('NULL');
			$table->tinyInteger('to_be_logged_out')->nullable()->default('0');
			$table->string('provider', 255)->nullable()->default('NULL');
			$table->string('provider_id', 255)->nullable()->default('NULL');
			$table->string('remember_token', 100)->nullable()->default('NULL');
			$table->timestamps();
			$table->timestamps();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}