<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user', function(Blueprint $table) {
			$table->foreign('user_type_id')->references('user_type_id')->on('user_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_info', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_info', function(Blueprint $table) {
			$table->foreign('gender_id')->references('gender_id')->on('gender')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_type', function(Blueprint $table) {
			$table->foreign('parent_type')->references('user_type_id')->on('user_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_info', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_info', function(Blueprint $table) {
			$table->foreign('created_by')->references('user_id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user', function(Blueprint $table) {
			$table->dropForeign('user_user_type_id_foreign');
		});
		Schema::table('user_info', function(Blueprint $table) {
			$table->dropForeign('user_info_user_id_foreign');
		});
		Schema::table('user_info', function(Blueprint $table) {
			$table->dropForeign('user_info_gender_id_foreign');
		});
		Schema::table('user_type', function(Blueprint $table) {
			$table->dropForeign('user_type_parent_type_foreign');
		});
		Schema::table('company_info', function(Blueprint $table) {
			$table->dropForeign('company_info_user_id_foreign');
		});
		Schema::table('company_info', function(Blueprint $table) {
			$table->dropForeign('company_info_created_by_foreign');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->dropForeign('user_profile_user_id_foreign');
		});
	}
}