<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserInfoTable extends Migration {

	public function up()
	{
		Schema::create('user_info', function(Blueprint $table) {
			$table->bigInteger('user_info_id', true)->unique();
			$table->bigInteger('user_id')->unsigned()->index();
			$table->string('first_name', 255);
			$table->string('last_name', 255);
			$table->integer('gender_id')->unsigned();
			$table->date('birthday');
			$table->datetime('created');
			$table->datetime('modified');
		});
	}

	public function down()
	{
		Schema::drop('user_info');
	}
}