<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserProfileTable extends Migration {

	public function up()
	{
		Schema::create('user_profile', function(Blueprint $table) {
			$table->bigInteger('user_profile_id', true)->unique();
			$table->bigInteger('user_id')->unsigned();
			$table->string('profile_picture', 255);
			$table->string('cover_picture', 255);
			$table->text('introduction');
			$table->datetime('created');
			$table->datetime('modified');
		});
	}

	public function down()
	{
		Schema::drop('user_profile');
	}
}