<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->bigInteger('user_id', true)->unique();
			$table->string('email', 255);
			$table->string('username');
			$table->string('password', 255);
			$table->integer('user_type_id')->unsigned();
			$table->datetime('created');
			$table->datetime('modified');
			$table->datetime('last_login');
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}