<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Images', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Votes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Votes', function(Blueprint $table) {
			$table->foreign('image_id')->references('id')->on('Images')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Friends', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Images', function(Blueprint $table) {
			$table->dropForeign('Images_user_id_foreign');
		});
		Schema::table('Votes', function(Blueprint $table) {
			$table->dropForeign('Votes_user_id_foreign');
		});
		Schema::table('Votes', function(Blueprint $table) {
			$table->dropForeign('Votes_image_id_foreign');
		});
		Schema::table('Friends', function(Blueprint $table) {
			$table->dropForeign('Friends_user_id_foreign');
		});
	}
}