<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('account_id');
			$table->string('name', 255);
			$table->string('description', 255);
			$table->string('location');
			$table->float('value');
			$table->string('currency');
			$table->float('probability');
			$table->string('challenges');
			$table->datetime('timestamps');
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}