<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeadsOverviewsTable extends Migration {

	public function up()
	{
		Schema::create('leads_overviews', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('lead_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('content', 255);
			$table->datetime('from');
			$table->datetime('to');
			$table->json('columns');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('leads_overviews');
	}
}