<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('leads_progress', function(Blueprint $table) {
			$table->foreign('lead_id')->references('id')->on('leads')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('leads_overviews', function(Blueprint $table) {
			$table->foreign('lead_id')->references('id')->on('leads')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('leads_overviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('assign_agents', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('assign_agents', function(Blueprint $table) {
			$table->foreign('lead_id')->references('id')->on('leads')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('leads_updates', function(Blueprint $table) {
			$table->foreign('lead_id')->references('id')->on('leads')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('updated_replies', function(Blueprint $table) {
			$table->foreign('update_id')->references('id')->on('leads_updates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('no action')
						->onUpdate('restrict');
		});
		Schema::table('contact_deals', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contact_deals', function(Blueprint $table) {
			$table->foreign('deal_id')->references('id')->on('deals')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('assignes', function(Blueprint $table) {
			$table->foreign('model_id')->references('id')->on('assignes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('assignes', function(Blueprint $table) {
			$table->foreign('model_name')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('leads_progress', function(Blueprint $table) {
			$table->dropForeign('leads_progress_lead_id_foreign');
		});
		Schema::table('leads_overviews', function(Blueprint $table) {
			$table->dropForeign('leads_overviews_lead_id_foreign');
		});
		Schema::table('leads_overviews', function(Blueprint $table) {
			$table->dropForeign('leads_overviews_user_id_foreign');
		});
		Schema::table('assign_agents', function(Blueprint $table) {
			$table->dropForeign('assign_agents_user_id_foreign');
		});
		Schema::table('assign_agents', function(Blueprint $table) {
			$table->dropForeign('assign_agents_lead_id_foreign');
		});
		Schema::table('leads_updates', function(Blueprint $table) {
			$table->dropForeign('leads_updates_lead_id_foreign');
		});
		Schema::table('updated_replies', function(Blueprint $table) {
			$table->dropForeign('updated_replies_update_id_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_job_id_foreign');
		});
		Schema::table('contact_deals', function(Blueprint $table) {
			$table->dropForeign('contact_deals_contact_id_foreign');
		});
		Schema::table('contact_deals', function(Blueprint $table) {
			$table->dropForeign('contact_deals_deal_id_foreign');
		});
		Schema::table('assignes', function(Blueprint $table) {
			$table->dropForeign('assignes_model_id_foreign');
		});
		Schema::table('assignes', function(Blueprint $table) {
			$table->dropForeign('assignes_model_name_foreign');
		});
	}
}