<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTripsTable extends Migration {

	public function up()
	{
		Schema::create('Trips', function(Blueprint $table) {
			$table->increments('id');
			$table->string('stock_num');
			$table->integer('from')->unsigned();
			$table->integer('to');
			$table->datetime('eta');
			$table->integer('dispatcher');
			$table->integer('driver');
			$table->integer('mgr_requested');
			$table->datetime('pickup');
			$table->datetime('delivered');
			$table->boolean('waiter');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Trips');
	}
}