<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartsTable extends Migration {

	public function up()
	{
		Schema::create('carts', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->bigInteger('product_id')->unsigned();
			$table->string('count')->nullable();
			$table->string('total_price')->nullable();
			$table->enum('status', array('cart', 'order'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('carts');
	}
}