<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('email');
			$table->string('watsapp_number');
			$table->bigInteger('city_id')->unsigned();
			$table->bigInteger('area_id')->unsigned();
			$table->string('fb_account');
			$table->enum('type', array('student', 'parent', 'instructor'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}