<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donation_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id');
			$table->timestamps();
			$table->string('name');
			$table->integer('age');
			$table->integer('blood_type_id');
			$table->integer('number_bags');
			$table->string('hospital_name');
			$table->string('hospital_address');
			$table->integer('town_id');
			$table->string('phone');
			$table->decimal('latitude', 10,8);
			$table->decimal('longitude', 10,8);
			$table->longText('notes');
			$table->integer('governorate_id');
		});
	}

	public function down()
	{
		Schema::drop('donation_requests');
	}
}