<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttachmentsTable extends Migration {

	public function up()
	{
		Schema::create('attachments', function(Blueprint $table) {
			$table->increments('id');
			$table->string('transaction_id');
			$table->string('name', 255);
			$table->text('description');
			$table->string('attachment_name', 255);
			$table->string('mime', 255)->nullable();
			$table->string('attachment_size', 255);
			$table->string('type', 255);
			$table->string('extension', 255);
			$table->string('attachment_src', 255);
			$table->boolean('is_main');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('attachments');
	}
}