<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('vacancy', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('company')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('offer', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('company')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('company')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_category_id_foreign');
		});
		Schema::table('vacancy', function(Blueprint $table) {
			$table->dropForeign('vacancy_company_id_foreign');
		});
		Schema::table('offer', function(Blueprint $table) {
			$table->dropForeign('offer_company_id_foreign');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_company_id_foreign');
		});
	}
}